'
' This program output the voice file DEMO.VOC
'

' $INCLUDE: 'SBC.BI'
' $INCLUDE: 'SBCSYS.BI'
' $INCLUDE: 'SBCVOICE.BI'

DECLARE FUNCTION LDVFILE% (filename$, segment%, offset%)
DECLARE SUB OUTVOC (buffer%())

REM $DYNAMIC
CLEAR

CLS

PRINT "SBK Basic Voice Output (memory version) Example"

' Following statements free memory for the loadable drivers.
' You must free sufficient memory for the loadable drivers.
' The free memory must be larger than the driver file size.

' Free 8K memory for the CT-VOICE.DRV at the moment
DUMMY = SETMEM(-8192)

' Allocate 180K buffer for voice data file
DIM buffer%(1 TO 180, 1 TO 512)

IF (SBGETENV% = 0) THEN
    IF SBCHKCRD% THEN
        IF SBTSTINT% THEN
            IF SBTSTDMA% >= 0 THEN

                ' Load CT-VOICE.DRV
                DRVADDX% = LOADDRV% ("CT-VOICE.DRV")

                ' If driver loaded successfully
                IF (DRVADDX% <> 0) THEN

                    ' Set driver address
                    CTVADDX (DRVADDX%)

                    ' Initialize driver
                    IF (SVMINIT% = 0) THEN
                        CALL SVMSPKER(INT(0))

                        ' Load voice file
                        IF (LDVFILE("DEMO.VOC", VARSEG(buffer%(1, 1)),_
                                     VARPTR(buffer%(1, 1))) <> 0) THEN
                            CALL OUTVOC(buffer%())
                        END IF

                        ' Terminate driver before exit
                        CALL SVMEXIT
                    END IF

                    ' Release memory allocated for CT-VOICE
                    CALL FREEMEM(DRVADDX%)
                END IF
            ELSE
                PRINT "Error on DMA channel."
            ENDIF
        ELSE
            PRINT "Error on interrupt."
        ENDIF
    ELSE
        PRINT "Sound Blaster Card not found or wrong I/O setting"
    ENDIF
ELSE
    PRINT "BLASTER environment variable not set or incomplete or invalid."
ENDIF


' Return memory to BASIC
DUMMY = SETMEM(8192)

END


' ------------------------------------------------------------------------ '

FUNCTION LOADDRV% (szDrvName$)

    DIM szDrvFile$, Handle%, dwFileLen&, wDrvSeg%


    LOADDRV% = 0

    ' search SOUND environment for driver
    szDrvFile$ = ENVIRON$("SOUND")

    IF (szDrvFile$ <> "") THEN
        szDrvFile$ = szDrvFile$ + "\DRV\" + szDrvName$

        IF (FINDFILE%(szDrvFile$) = 0) THEN
            szDrvFile$ = ""
        ENDIF
    ENDIF

    ' search the current directory for driver
    IF (szDrvFile$ = "") THEN
        szDrvFile$ = szDrvName$
    ENDIF

    IF (FINDFILE%(szDrvFile$) <> 0) THEN
        Handle% = DOSOPEN%(szDrvFile$)

        IF (Handle% <> 0) THEN
            dwFileLen& = FILESIZE(Handle%)

            wDrvSeg% = ALLOCMEM(INT((dwFileLen& + 15) / 16))

            IF (wDrvSeg% <> 0) THEN
                IF DOSREAD%(Handle%, INT(0), wDrvSeg%, dwFileLen&) THEN
                    LOADDRV% = wDrvSeg%
                ENDIF
            ENDIF

            DOSCLOSE(Handle%)
        ELSE
            PRINT "Error in opening " + szDrvFile$
        ENDIF
    ELSE
        PRINT "Driver file " + szDrvName$ + " does not exist ..."
    ENDIF

END FUNCTION

' ------------------------------------------------------------------------ '

REM $STATIC
FUNCTION LDVFILE% (filename$, segment%, offset%)

' This function loads voice file into buffer%

    DIM handle%, filelen&

	handle% = DOSOPEN(filename$)
	LDVFILE% = 0

	IF (handle% <> 0) THEN
        filelen& = FILESIZE&(handle%)

        IF (DOSREAD%(handle%, offset%, segment%, filelen&) <> 0) THEN
            LDVFILE% = 1
        ELSE
            PRINT "Read file error."
        END IF

        DOSCLOSE (handle%)
	ELSE
        PRINT "Open " + filename$ + "error."
	END IF

END FUNCTION


SUB OUTVOC (buffer%())

' This function output the voice file loaded and check for the keyboard
' input to pause, stop and break the voice output

    DIM userkey AS INTEGER, voice AS INTEGER

	' Turn on DAC speaker
	CALL SVMSPKER(INT(1))

	voice% = buffer%(11, 1)

	IF (SVMOUTPUT%(buffer%(voice% / 2 + 1, 1)) = 0) THEN

        WHILE CTVOICE% <> 0
            c$ = INKEY$

            IF c$ <> "" THEN
                userkey = INT(ASC(LEFT$(c$, 1)))

                SELECT CASE userkey
                    CASE ASC("S"), ASC("s"), 27
                        CALL SVMSTOP
                    CASE ASC("P"), ASC("p")
                        dummy = SVMPAUSE%
                    CASE ASC("C"), ASC("c")
                        dummy = SVMCONT%
                    CASE ASC("B"), ASC("b")
                        dummy = SVMBREAK% (INT(1))
                END SELECT
            END IF
        WEND
    END IF

	' Turn off DAC speaker
	CALL SVMSPKER(INT(0))

END SUB
